/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

const mat3 rgb2yuv_mat = mat3(
  0.2126,    0.7152,   0.0722,
 -0.09991,  -0.33609,  0.436,
  0.615,    -0.55861, -0.05639
);

const mat3 yuv2rgb_mat = mat3(
  1.0,  0.0,      1.28033,
  1.0, -0.21482, -0.38059,
  1.0,  2.12798,  0.0
);

vec3 rgb2yuv(vec3 rgb) {
  return rgb * rgb2yuv_mat;
}

vec3 yuv2rgb(vec3 rgb) {
  return rgb * yuv2rgb_mat;
}

vec2 cartesian2polar(vec2 uv) {
  float r = sqrt(pow(uv.x, 2.0) + pow(uv.y, 2.0));
  float fi = atan(uv.y, uv.x);
  return vec2(r, fi);
}

vec2 polar2cartesian(vec2 uv) {  
  return vec2(uv.x*cos(uv.y), uv.x*sin(uv.y));   
}

vec2 rotate2(vec2 v, float fi) {
  return v*mat2(cos(fi), -sin(fi), sin(fi), cos(fi));
}

// rgb->yuv yuv->polar -> rotate yuv->right
void main ( void )
{
   vec2 uv = gl_FragCoord.xy / iResolution.xy;
   uv.y = -uv.y;
   vec4 color = texture2D(iChannel0, uv); 
    
   vec3 yuv = rgb2yuv(color.rgb);
   //vec2 polar = cartesian2polar(yuv.yz);
   //polar.y += iGlobalTime*2.0;
   //vec2 cartesian = polar2cartesian(polar);    
   //vec3 rgb = yuv2rgb(vec3(yuv.x, cartesian));
   
   vec3 rgb = yuv2rgb(vec3(yuv.x, rotate2(yuv.yz, iGlobalTime)));
   color = vec4(rgb, 1.0);
   gl_FragColor = color;
}